package com.elitescloud.cloudt.messenger.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.Assert;

import javax.validation.constraints.NotBlank;

/**
 * 文件.
 * <p>
 * 来自文件服务器的文件
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "文件信息")
public class FileMessageAttachmentVO implements MessageAttachmentVO {
    private static final long serialVersionUID = -107515102437729919L;

    /**
     * 文件编码
     */
    @NotBlank(message = "文件编码为空")
    @ApiModelProperty(value = "文件编码", position = 11)
    private String fileCode;

    @Override
    public void validate() {
        Assert.hasText(fileCode, "附件的文件编码为空");
    }
}
