package com.elitescloud.cloudt.messenger.model.config;

import java.nio.charset.StandardCharsets;
import java.util.Properties;

/**
 * Email消息配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/23
 */
public class EmailMessagePropertiesVO implements MessagePropertiesVO {
    private static final long serialVersionUID = -3121503243236474327L;

    /**
     * 协议
     */
    private String protocol;

    /**
     * 邮件服务器主机
     */
    private String host;

    /**
     * 邮件服务器端口
     */
    private Integer port;

    /**
     * 发件账号
     */
    private String username;

    /**
     * 发件账号显示名称
     */
    private String showName;

    /**
     * 发件账号的密码
     */
    private String password;

    /**
     * 邮件编码
     */
    private String encoding = StandardCharsets.UTF_8.name();

    /**
     * 自定义java配置
     */
    private Properties javaMailProperties;

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getShowName() {
        return showName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Properties getJavaMailProperties() {
        return javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }
}
