package com.elitescloud.coord.messenger.sender.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.Application;
import com.elitescloud.coord.messenger.sender.provider.param.SimpleEmailDTO;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateEmailDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 邮件服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@FeignClient(name = Application.NAME, path = EmailRpcService.URI)
@Validated
public interface EmailRpcService {
    String URI = Application.URI_PREFIX + "/email";

    /**
     * 发送模板邮件
     *
     * @param emailDTO 邮件参数
     * @return 发送结果
     */
    @PostMapping(value = "/sendTemplateEmail")
    ApiResult<Boolean> sendTemplateEmail(@RequestBody @Valid TemplateEmailDTO emailDTO);

    /**
     * 发送普通邮件
     *
     * @param emailDTO 邮件参数
     * @return 发送结果
     */
    @PostMapping(value = "/sendSimpleEmail")
    ApiResult<Boolean> sendSimpleEmail(@RequestBody @Valid SimpleEmailDTO emailDTO);
}
