package com.elitescloud.coord.messenger.sender.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.Application;
import com.elitescloud.coord.messenger.sender.provider.param.GeneralDubboCarrier;
import com.elitescloud.coord.messenger.sender.provider.param.SimpleMailCarrier;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * 复合消息服务接口
 */
@FeignClient(name = Application.NAME, path = MsgCarrierDubboService.URI)
@Validated
public interface MsgCarrierDubboService {
    String URI = Application.URI_PREFIX + "/msg_carrier";

    /**
     * 简单邮件发送，旧接口，提供给国药SRM使用添加，之后会删除废弃
     *
     * @param simpleMailCarrier
     * @return
     */
    @PostMapping(value = "/simplySend")
    ApiResult<?> simplySend(@RequestBody @Valid SimpleMailCarrier simpleMailCarrier);

    /**
     * 通用发送接口，支持多种，批量发送方式，异步调用
     *
     * @param carriers 消息载体
     * @return 发送结果
     */
    @PostMapping(value = "/generalSend")
    ApiResult<Object> generalSend(@RequestBody List<GeneralDubboCarrier> carriers);
}
