package com.elitescloud.coord.messenger.sender.provider.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("简易邮件发送封装对象，用于直接提交邮件发送请求")
public class SimpleMailCarrier implements Serializable {
    private static final long serialVersionUID = -6863290449582294348L;

    @ApiModelProperty("发件人地址")
    private String from;

    @ApiModelProperty("收件人列表")
    private String[] tos;

    @ApiModelProperty("主题")
    private String subject;

    @ApiModelProperty("是否富文本内容")
    private Boolean isRichContent;

    @ApiModelProperty("内容文本")
    private String content;

    @ApiModelProperty("邮件配置编码")
    private String mailConfigCode;
}
