package com.elitescloud.coord.messenger.sender.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.Application;
import com.elitescloud.coord.messenger.sender.provider.param.SimpleSmsDTO;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 短信服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@FeignClient(name = Application.NAME, path = SmsRpcService.URI)
@Validated
public interface SmsRpcService {
    String URI = Application.URI_PREFIX + "/sms";

    /**
     * 发送模板短信
     *
     * @param smsDTO 短信参数
     * @return 发送结果
     */
    @PostMapping(value = "/sendTemplateMsg")
    ApiResult<Boolean> sendTemplateMsg(@RequestBody @Valid TemplateSmsDTO smsDTO);

    /**
     * 发送普通短信
     *
     * @param smsDTO 短信参数
     * @return 发送结果
     */
    @PostMapping(value = "/sendSimpleMsg")
    ApiResult<Boolean> sendSimpleMsg(@RequestBody @Valid SimpleSmsDTO smsDTO);
}
