package com.elitescloud.coord.messenger.sender.provider.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Set;

/**
 * 基本短信信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@Data
public abstract class BaseSmsDTO implements Serializable {
    private static final long serialVersionUID = -6314560539100297222L;

    /**
     * 业务类型
     */
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    /**
     * 短信主题
     */
    private String subject;

    /**
     * 手机号
     */
    @NotEmpty(message = "手机号不能为空")
    private Set<String> mobiles;
}
