package com.elitescloud.coord.messenger.sender.provider.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * @author Chris
 * @date 2021-08-24
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("简易发送封装对象，用于直接提交短信发送请求")
public class GeneralDubboCarrier implements Serializable {

    private static final long serialVersionUID = 648475961509070526L;

    /**
     * 消息发送地址，邮件地址，手机号，系统账号，根据接口要求提供
     */
    @ApiModelProperty("消息发送地址，邮件地址，手机号，系统账号，根据接口要求提供")
    private String from;

    /**
     * 消息接收地址列表，邮件地址，手机号，或系统账号，根据接口要求提供
     */
    @ApiModelProperty("消息接收地址列表，邮件地址，手机号，或系统账号，根据接口要求提供")
    private String[] tos;

    /**
     * 主题
     */
    @ApiModelProperty("主题")
    private String subject;

    /**
     * 标题
     */
    @ApiModelProperty("标题")
    private String title;

    /**
     * 模板编号
     */
    @ApiModelProperty("模板编号")
    private String templateCode;

    /**
     * 消息内容对象，针对模板的内容替换
     */
    @ApiModelProperty("消息内容对象，针对模板的内容替换")
    private Map<String, Object> templateValues;

    /**
     * 是否富文本内容，只针对邮件有效
     */
    @ApiModelProperty("是否富文本内容，只针对邮件有效")
    private Boolean isRichContent;

    /**
     * 消息内容，如果模板ID为null或0，将作为默认内容发送
     */
    @ApiModelProperty("消息内容，如果模板ID为null或0，将作为默认内容发送")
    private String pureContent;

    /**
     * 发送类型
     * {@link com.elitescloud.coord.messenger.sender.provider.TransTypeEnum}
     */
    @ApiModelProperty("发送类型")
    private String transType;

    /**
     * 发送方式编码, 类型为MAIL，则邮件配置编码；类型为SMS，则短信配置编码；类型为SITE，则无配置
     */
    @ApiModelProperty("发送方式编码, 类型为MAIL，则邮件配置编码；类型为SMS，则短信配置编码；类型为SITE，则无配置")
    private String transCode;

    /**
     * 扩展信息，针对具体不同的sender可能有不同的配置
     */
    @ApiModelProperty("扩展信息，针对具体不同的sender可能有不同的配置")
    private Map<String, String> extend;
}
