package com.elitescloud.cloudt.messenger.common;

import cn.hutool.core.text.CharSequenceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消息发送状态.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
public enum MsgSendStatusEnum {
    /**
     * 发送状态
     */
    WAIT("待发送"),
    CANCELED("已取消"),
    SENDING("发送中"),
    SENT("已发送"),
    SENT_SUC("发送成功"),
    SENT_FAIL("发送失败"),
    RECEIVED("已接收")
    ;

    private static final Logger LOG = LoggerFactory.getLogger(MsgSendStatusEnum.class);

    private final String description;

    MsgSendStatusEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, MsgSendStatusEnum> MAP = Arrays.stream(MsgSendStatusEnum.values())
            .collect(Collectors.toMap(MsgSendStatusEnum::name, t -> t, (t1, t2) -> t1));

    public static MsgSendStatusEnum parse(String val) {
        if (CharSequenceUtil.isBlank(val)) {
            return null;
        }

        var value = MAP.get(val);
        if (value == null) {
            LOG.error("不支持的枚举类型：{}，{}", MsgSendStatusEnum.class.getName(), val);
        }
        return value;
    }
}
