package com.elitescloud.cloudt.messenger.model;

import cn.hutool.core.util.ArrayUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.Assert;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

/**
 * 字节.
 * <p>
 * 文件流字节
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "字节流消息附件")
public class ByteMessageAttachmentVO implements MessageAttachmentVO {
    private static final long serialVersionUID = -107515102437729919L;

    /**
     * 文件流
     */
    @NotEmpty(message = "文件流为空")
    @ApiModelProperty(value = "文件流", position = 11, required = true)
    private byte[] fileBytes;

    /**
     * 文件名称
     */
    @NotBlank(message = "文件名称为空")
    @ApiModelProperty(value = "文件显示名称", position = 12, required = true)
    private String showName;

    /**
     * 文件类型
     * <p>
     * mime-type，如application/octet-stream
     */
    @ApiModelProperty(value = "文件类型", position = 13)
    private String contentType;

    @Override
    public void validate() {
        Assert.isTrue(ArrayUtil.isNotEmpty(fileBytes), "附件的字节数据为空");
        Assert.hasText(showName, "附件名称为空");
    }
}
