package com.elitescloud.cloudt.messenger.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 消息账户.
 * <p>
 * 消息发送者、接收者等
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
@Data
@ApiModel(description = "消息账户")
public class MessageAccountVO implements Serializable {
    private static final long serialVersionUID = 415225250154159200L;

    /**
     * 账号
     */
    @NotBlank(message = "账号不能为空")
    @ApiModelProperty(value = "账号", position = 1)
    private String account;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", position = 2)
    private String nickName;

    public MessageAccountVO(String account, String nickName) {
        this.account = account;
        this.nickName = nickName;
    }

    public MessageAccountVO(String account) {
        this.account = account;
    }

    public MessageAccountVO() {
    }
}
