package com.elitescloud.cloudt.messenger.model.config;

import com.elitescloud.cloudt.messenger.common.MesssengerConstant;

import java.nio.charset.StandardCharsets;
import java.util.Properties;

/**
 * Email消息配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/23
 */
public class EmailMessagePropertiesVO implements MessagePropertiesVO {
    private static final long serialVersionUID = -3121503243236474327L;

    /**
     * 协议
     */
    private String protocol;

    /**
     * 邮件服务器主机
     */
    private String host;

    /**
     * 邮件服务器端口
     */
    private Integer port;

    /**
     * 发件账号
     */
    private String username;

    /**
     * 发件账号显示名称
     */
    private String showName;

    /**
     * 发件账号的密码
     */
    private String password;

    /**
     * 邮件编码
     */
    private String encoding = StandardCharsets.UTF_8.name();

    /**
     * 是否启用ssl
     * <p>
     * 相当于{@link #javaMailProperties}的属性mail.smtp.ssl.enable
     */
    private Boolean sslEnabled = false;

    /**
     * 是否启用auth
     * <p>
     * 相当于{@link #javaMailProperties}的属性mail.smtp.auth
     */
    private Boolean auth = false;

    /**
     * 自定义java配置
     */
    private Properties javaMailProperties;

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getShowName() {
        return showName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getSslEnabled() {
        return sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Boolean getAuth() {
        return auth;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public Properties getJavaMailProperties() {
        return normalizeJavaProperties();
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public Properties normalizeJavaProperties() {
        Properties properties = new Properties();
        if (javaMailProperties != null) {
            properties.putAll(javaMailProperties);
        }
        if (!properties.containsKey(MesssengerConstant.EMAIL_PROP_SSL)) {
            if (Boolean.TRUE.equals(getSslEnabled())) {
                properties.put(MesssengerConstant.EMAIL_PROP_SSL, true);
            }
        }

        if (!properties.containsKey(MesssengerConstant.EMAIL_PROP_AUTH)) {
            if (Boolean.TRUE.equals(getAuth())) {
                properties.put(MesssengerConstant.EMAIL_PROP_AUTH, true);
            }
        }

        return properties;
    }
}
