/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization;

import com.elitescloud.boot.auth.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitescloud.cloudt.authorization.TeleworkProperties;
import com.elitescloud.cloudt.authorization.provider.TwAuthProvider;
import com.elitescloud.cloudt.authorization.tw4.Tw4TicketAuthenticationProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TeleworkProperties.class})
public class TwAuthorizationConfig {
    private final TeleworkProperties teleworkProperties;

    public TwAuthorizationConfig(TeleworkProperties teleworkProperties) {
        this.teleworkProperties = teleworkProperties;
    }

    @Bean
    public LoginFilterCustomizer<HttpSecurity> loginFilterCustomizerTw() {
        return customizer -> {
            ArrayList<Tw4TicketAuthenticationProvider> providers = new ArrayList<Tw4TicketAuthenticationProvider>(customizer.defaultAuthenticationProviders());
            providers.add(new Tw4TicketAuthenticationProvider());
            customizer.addCustomAuthenticationProvider(providers);
        };
    }

    @Bean
    public TwAuthProvider twAuthProvider(ObjectMapper objectMapper) {
        return new TwAuthProvider(this.teleworkProperties, objectMapper);
    }
}

