/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.provider;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.cloudt.authorization.TeleworkProperties;
import com.elitescloud.cloudt.authorization.model.TwAuthRespDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class TwAuthProvider {
    private static final Logger log = LogManager.getLogger(TwAuthProvider.class);
    public final TeleworkProperties teleworkProperties;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    public TwAuthProvider(TeleworkProperties teleworkProperties, ObjectMapper objectMapper) {
        this.teleworkProperties = teleworkProperties;
        this.objectMapper = objectMapper;
        this.restTemplate = RestTemplateFactory.instance();
    }

    public String authEmail(String ticket) {
        String url = this.teleworkProperties.getAuthEndpoint();
        if (!StringUtils.hasText((String)url)) {
            throw new BusinessException("authEndpoint\u672a\u914d\u7f6e");
        }
        try {
            log.info("tw\u8fdb\u884c\u8ba4\u8bc1\uff1a{}\uff0c{}", (Object)url, (Object)ticket);
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, null, String.class, new Object[]{ticket});
            if (resp.getStatusCode().is2xxSuccessful() && resp.getBody() != null) {
                log.info("tw\u8ba4\u8bc1\u8fd4\u56de\u7ed3\u679c\uff1a{}", resp.getBody());
                TwAuthRespDTO respDTO = (TwAuthRespDTO)this.objectMapper.readValue((String)resp.getBody(), TwAuthRespDTO.class);
                return respDTO.getAppLoginEmail();
            }
            log.error("tw\u8ba4\u8bc1\u4e2d\u5fc3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)resp.getStatusCode());
        }
        catch (Exception e) {
            throw new BusinessException("tw\u8ba4\u8bc1\u6388\u6743\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

