/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.tw4;

import cn.hutool.core.util.BooleanUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.authorization.TeleworkProperties;
import com.elitescloud.cloudt.authorization.provider.TwAuthProvider;
import com.elitescloud.cloudt.authorization.tw4.Tw4TicketAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class Tw4TicketAuthenticationProvider
extends AbstractCustomAuthenticationProvider<Tw4TicketAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(Tw4TicketAuthenticationProvider.class);
    private TeleworkProperties teleworkProperties;
    private TwAuthProvider twAuthProvider;

    protected GeneralUserDetails retrieveUser(Tw4TicketAuthenticationToken authentication) throws AuthenticationException {
        String ticket = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)ticket)) {
            throw new AuthorizationException("\u767b\u5f55\u5931\u8d25\uff0cticket\u4e3a\u7a7a");
        }
        if (BooleanUtil.isFalse((Boolean)this.teleworkProperties.getEnabledAuth())) {
            throw new AuthorizationException("\u672a\u542f\u7528tw4\u8ba4\u8bc1\u6388\u6743\u767b\u5f55");
        }
        String email = null;
        try {
            email = this.twAuthProvider.authEmail(ticket);
        }
        catch (Exception e) {
            throw new AuthorizationException("\u8ba4\u8bc1\u6388\u6743\u5931\u8d25", (Throwable)e);
        }
        if (!StringUtils.hasText((String)email)) {
            throw new AuthorizationException("tw\u8ba4\u8bc1\u4e2d\u5fc3\u672a\u83b7\u53d6\u5230\u7528\u6237\u90ae\u7bb1");
        }
        try {
            return this.userDetailManager.loadUserByEmail(email);
        }
        catch (UsernameNotFoundException e) {
            throw new AuthorizationException("\u90ae\u7bb1\u4e0d\u5b58\u5728");
        }
    }

    @Autowired
    public void setTeleworkProperties(TeleworkProperties teleworkProperties) {
        this.teleworkProperties = teleworkProperties;
    }

    @Autowired
    public void setTwAuthProvider(TwAuthProvider twAuthProvider) {
        this.twAuthProvider = twAuthProvider;
    }
}

