package com.elitesland.sjww.yst.ss.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sjww.yst.ss.Application;
import com.elitesland.sjww.yst.ss.rpc.param.YstDemoDTO;
import com.elitesland.sjww.yst.ss.rpc.param.query.OneedpOpenApiToken;
import com.elitesland.sjww.yst.ss.rpc.param.query.UserTokenParam;
import com.elitesland.sjww.yst.ss.rpc.param.query.YstDemoQueryDTO;
import com.elitesland.sjww.yst.ss.rpc.param.save.YstDemoInsertDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * DEMO服务接口.
 *
 * @author nc
 * @date 20250221
 */
@FeignClient(name = Application.NAME, path = OneedpRpcService.URI)
@Validated
public interface OneedpRpcService {
    String URI = Application.URI_PREFIX + "/oneedp";

    @GetMapping(value = "/userToken")
    ApiResult<OneedpOpenApiToken> openApiToken();

    @PostMapping(value = "/userToken")
    ApiResult<String> userToken(@RequestBody UserTokenParam param);
}
