package com.elitesland.yst.dms.osf.rpc.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * demo相关信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/1
 */
@Data
@Accessors(chain = true)
public class OperationChannelRpcDTO implements Serializable {
    private static final long serialVersionUID = -356206361738410377L;

    private Long id;

    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    @ApiModelProperty(value = "渠道状态")
    private String status;

    @ApiModelProperty(value = "渠道状态名称")
    private String statusName;

    /**
     * 上级渠道Id
     */
    @ApiModelProperty(value = "上级渠道Id")
    private Long upperChannelId;

    /**
     * 上级渠道编码
     */
    @ApiModelProperty(value = "上级渠道编码")
    private String upperChannelCode;

    /**
     * 上级渠道名称
     */
    @ApiModelProperty(value = "上级渠道名称")
    private String upperChannelName;

    /**
     * 渠道层级
     */
    @ApiModelProperty(value = "渠道层级")
    private Integer level;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    /**
     * 渠道负责人用户编码
     */
    @ApiModelProperty(value = "渠道负责人用户编码")
    private List<String> channelManagerUserCodes;

    /**
     * 渠道负责人用户名称
     */
    @ApiModelProperty(value = "渠道负责人用户名称")
    private List<String> channelManagerUserNames;

    /**
     * 库区编码
     */
    @ApiModelProperty(value = "渠道描述")
    private String remark;

    /**
     * sap销售办公室
     */
    @ApiModelProperty(value = "sap销售办公室")
    private String sapSalesOrg;

    @ApiModelProperty(value = "sap销售办公室")
    private String sapSalesOrgName;

    /**
     * sap销售组
     */
    @ApiModelProperty(value = "sap销售组")
    private String sapSalesGroup;

    @ApiModelProperty(value = "sap销售组")
    private String sapSalesGroupName;

    /**
     * sap销售渠道
     */
    @ApiModelProperty(value = "sap销售渠道")
    private String sapSalesChannel;

    @ApiModelProperty(value = "sap销售渠道")
    private String sapSalesChannelName;

    /**
     * sap利润中心
     */
    @ApiModelProperty(value = "sap利润中心")
    private String sapProfitCenter;

    @ApiModelProperty(value = "信用控制维度")
    private String creditControlDimension;

    @ApiModelProperty(value = "信用控制维度")
    private String creditControlDimensionName;

    /**
     * 子渠道
     */
    @ApiModelProperty(value = "子渠道")
    private List<ChildChannel> childChannels;

    /**
     * 子渠道
     */
    @Data
    public static class ChildChannel {
        /**
         * 渠道Id
         */
        private Long id;

        /**
         * 渠道编码
         */
        private String channelCode;

        /**
         * 渠道名称
         */
        private String channelName;
    }
}
