package com.elitesland.yst.dms.osf.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.dms.osf.rpc.param.YstDemoDTO;
import com.elitesland.yst.dms.osf.rpc.param.query.YstDemoQueryDTO;
import com.elitesland.yst.dms.osf.rpc.param.save.YstDemoInsertDTO;
import com.elitesland.yst.dms.osf.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * DEMO服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@FeignClient(name = Application.NAME, path = DemoRpcService.URI)
@Validated
public interface DemoRpcService {
    String URI = Application.URI_PREFIX + "/demo";

    /**
     * 是否已就绪
     *
     * @return 是否已就绪
     */
    @GetMapping(value = "/isReady")
    ApiResult<Boolean> isReady();

    /**
     * 新增数据
     *
     * @param insertDTO 新增数据信息
     * @return 数据ID
     */
    @PostMapping(value = "/add")
    ApiResult<Long> add(@RequestBody @Valid YstDemoInsertDTO insertDTO);

    /**
     * 查询DEMO数据
     *
     * @param queryDTO 查询参数
     * @return 查询结果
     */
    @PostMapping(value = "/query")
    ApiResult<List<YstDemoDTO>> query(@RequestBody YstDemoQueryDTO queryDTO);
}
