package com.elitesland.yst.dms.osf.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.dms.osf.Application;
import com.elitesland.yst.dms.osf.rpc.param.OperationChannelRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 经营渠道rpc.
 */
@FeignClient(name = Application.NAME, path = OperationChannelRpcService.URI)
@Validated
public interface OperationChannelRpcService {
    String URI = Application.URI_PREFIX + "/channel";

    /**
     * 查询一级渠道
     */
    @PostMapping(value = "/findFirstChannelByName")
    ApiResult<List<OperationChannelRpcDTO>> findFirstChannelByName(@RequestBody List<String> channelNames);

    @PostMapping(value = "/findFirstChannelByCode")
    ApiResult<List<OperationChannelRpcDTO>> findFirstChannelByCode(@RequestBody List<String> channelCodes);

    @PostMapping(value = "/findChannelByCode")
    ApiResult<List<OperationChannelRpcDTO>> findChannelByCode(@RequestBody List<String> channelCodes);
}
