package com.elitesland.yst.dms.osf.rpc.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CustRpcDTO implements Serializable {

    @ApiModelProperty(value = "申请单id")
    private Long id;

    /**
     * 客户类型
     */
    @ApiModelProperty(value = "客户类型")
    private String custType;

    /**
     * 客户类型名称
     */
    @ApiModelProperty(value = "客户类型名称")
    private String custTypeName;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    private String companyName;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty(value = "统一社会信用代码")
    private String socialCreditCode;

    /**
     * 委托人
     */
    @ApiModelProperty(value = "委托人")
    private String principal;

    /**
     * 委托人手机号
     */
    @ApiModelProperty(value = "委托人手机号")
    private String principalPhone;

    /**
     * 个人客户 姓名
     */
    @ApiModelProperty(value = "个人客户 姓名")
    private String personName;

    /**
     * 个人客户 身份证号
     */
    @ApiModelProperty(value = "个人客户 身份证号")
    private String idCardNo;

    /**
     * 客户分类编码 三级编码
     */
    @ApiModelProperty(value = "客户分类编码 三级编码")
    private String custCategoryCode;

    /**
     * 客户分类名称 三级名称
     */
    @ApiModelProperty(value = "客户分类名称 三级名称")
    private String custCategoryName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String custName;

    /**
     * 客户简称
     */
    @ApiModelProperty(value = "客户简称")
    private String custShortName;

    /**
     * 运营渠道编码
     */
    @ApiModelProperty(value = "运营渠道编码")
    private String operationChannelCode;

    /**
     * 运营渠道名称
     */
    @ApiModelProperty(value = "运营渠道名称")
    private String operationChannelName;

    /**
     * 客户报税分组
     */
    @ApiModelProperty(value = "客户报税分组")
    private String reportTaxGroup;

    /**
     * 客户报税分组名称
     */
    @ApiModelProperty(value = "客户报税分组名称")
    private String reportTaxGroupName;

    /**
     * 币种
     */
    @ApiModelProperty(value = "币种")
    private String currCode;

    /**
     * 币种名称
     */
    @ApiModelProperty(value = "币种名称")
    private String currName;

    /**
     * 关联公司编码
     */
    @ApiModelProperty(value = "关联公司编码")
    private String relateOuCode;

    /**
     * 关联公司名称
     */
    @ApiModelProperty(value = "关联公司名称")
    private String relateOuName;

    /**
     * 合作状态
     */
    @ApiModelProperty(value = "合作状态")
    private String workStatue;

    /**
     * 合作状态名称
     */
    @ApiModelProperty(value = "合作状态名称")
    private String workStatueName;

    /**
     * 所属集团公司 即客户编码
     */
    @ApiModelProperty(value = "所属集团公司 即客户编码")
    private String groupCustCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "所属集团公司 客户名称")
    private String groupCustName;

    /**
     * 省
     */
    @ApiModelProperty(value = "省")
    private String province;

    /**
     * 省名称
     */
    @ApiModelProperty(value = "省名称")
    private String provinceName;

    /**
     * 市
     */
    @ApiModelProperty(value = "市")
    private String city;

    /**
     * 市名称
     */
    @ApiModelProperty(value = "市名称")
    private String cityName;

    /**
     * 区县
     */
    @ApiModelProperty(value = "区县")
    private String county;

    /**
     * 区县名称
     */
    @ApiModelProperty(value = "区县名称")
    private String countyName;

    /**
     * 是否开票
     */
    @ApiModelProperty(value = "是否开票")
    private Boolean canTicket;

    /**
     * 是否推送金税
     */
    @ApiModelProperty(value = "是否推送金税")
    private Boolean pushGolden;

    /**
     * 是否代付方
     */
    @ApiModelProperty(value = "是否代付方")
    private Boolean behalfPay;

    /**
     * 是否要求实退数
     */
    @ApiModelProperty(value = "是否要求实退数")
    private Boolean requireRealRtnQty;

    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String ticketType;

    /**
     * 开票类型名称
     */
    @ApiModelProperty(value = "开票类型名称")
    private String ticketTypeName;

    /**
     * 开票名称
     */
    @ApiModelProperty(value = "开票名称")
    private String ticketName;

    /**
     * 税号
     */
    @ApiModelProperty(value = "税号")
    private String taxNo;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 提前开票许可
     */
    @ApiModelProperty(value = "提前开票许可")
    private Boolean beforeTicket;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 客户银行资料
     */
    @ApiModelProperty(value = "客户银行资料")
    private List<CustBankRespVO> bankRespVOS;

    @ApiModelProperty(value = "客户地址")
    private List<CustAddressRespVO> addressRespVOS;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;

    @Data
    public static class CustAddressRespVO implements Serializable {
        /**
         * 地址名称
         */
        @ApiModelProperty(value = "地址名称")
        private String addressName;

        /**
         * 默认地址
         */
        @ApiModelProperty(value = "默认地址")
        private Boolean defaultAddress;

        /**
         * 地址类型
         */
        @ApiModelProperty(value = "地址类型")
        private String addressType;

        /**
         * 地址类型名称
         */
        @ApiModelProperty(value = "地址类型名称")
        private String addressTypeName;

        /**
         * 省份
         */
        @ApiModelProperty(value = "省份")
        private String province;

        /**
         * 省份名称
         */
        @ApiModelProperty(value = "省份名称")
        private String provinceName;

        /**
         * 城市
         */
        @ApiModelProperty(value = "城市")
        private String city;

        /**
         * 城市名称
         */
        @ApiModelProperty(value = "城市名称")
        private String cityName;

        /**
         * 区县
         */
        @ApiModelProperty(value = "区县")
        private String district;

        /**
         * 区县名称
         */
        @ApiModelProperty(value = "区县名称")
        private String districtName;

        /**
         * 详细地址
         */
        @ApiModelProperty(value = "详细地址")
        private String detailAddress;

        /**
         * 经度
         */
        @ApiModelProperty(value = "经度")
        private double longitude;

        /**
         * 纬度
         */
        @ApiModelProperty(value = "纬度")
        private double latitude;

        /**
         * 联系人1
         */
        @ApiModelProperty(value = "联系人1")
        private String contact1;

        /**
         * 联系电话1
         */
        @ApiModelProperty(value = "联系电话1")
        private String contactPhone1;

        /**
         * 联系人2
         */
        @ApiModelProperty(value = "联系人2")
        private String contact2;

        /**
         * 联系电话2
         */
        @ApiModelProperty(value = "联系电话2")
        private String contactPhone2;

        /**
         * 联系人3
         */
        @ApiModelProperty(value = "联系人3")
        private String contact3;

        /**
         * 联系电话3
         */
        @ApiModelProperty(value = "联系电话3")
        private String contactPhone3;

        /**
         * 联系人4
         */
        @ApiModelProperty(value = "联系人4")
        private String contact4;

        /**
         * 联系电话4
         */
        @ApiModelProperty(value = "联系电话4")
        private String contactPhone4;

        /**
         * 联系人5
         */
        @ApiModelProperty(value = "联系人5")
        private String contact5;

        /**
         * 联系电话5
         */
        @ApiModelProperty(value = "联系电话5")
        private String contactPhone5;
    }

    @Data
    public static class CustBankRespVO implements Serializable {
        /**
         * 默认
         */
        @ApiModelProperty(value = "默认")
        private Boolean defaultBank;

        /**
         * 开户行
         */
        @ApiModelProperty(value = "开户行")
        private String openingBank;

        /**
         * 账号
         */
        @ApiModelProperty(value = "账号")
        private String accountNo;

        /**
         * 户名
         */
        @ApiModelProperty(value = "户名")
        private String accountName;

        /**
         * 币种
         */
        @ApiModelProperty(value = "币种")
        private String currCode;

        /**
         * 币种名称
         */
        @ApiModelProperty(value = "币种名称")
        private String currName;
    }
}


