package com.elitescloud.cloudt.sys.component.med;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serial;

/**
 * 医药基础实体类-商品.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/15 周一
 */
@Getter
@Setter
@MappedSuperclass
public class BaseModelMedItem extends CustomFieldBaseModel {
    @Serial
    private static final long serialVersionUID = 8543635117696143981L;

    @Column(length = 64)
    @Comment(value = "商品编码")
    private String itemCode;

    @Column(length = 64)
    @Comment(value = "商品名称")
    private String itemName;

    @Column(length = 64)
    @Comment(value = "通用名称")
    private String generalName;

    @Column(length = 64)
    @Comment(value = "商品名")
    private String productName;

    @Column(length = 64)
    @Comment(value = "英文名称")
    private String englishName;

    @Column(length = 64)
    @Comment(value = "规格型号")
    private String spec;

    @Column(length = 64)
    @Comment(value = "浓度规格")
    private String concSpec;

    @Column(length = 64)
    @Comment(value = "生产厂家")
    private String manuFactory;
    @Column(length = 64)
    @Comment(value = "生产厂家名称")
    private String manuFactoryName;

    @Column(length = 64)
    @Comment(value = "批准文号")
    private String approvalNumber;

    @Column(length = 64)
    @Comment(value = "产地")
    private String origin;

    @Column(length = 64)
    @Comment(value = "剂型, [UDC]yst-supp:DOSAGE_FORM")
    private String dosageForm;
    @Column(length = 64)
    @Comment(value = "剂型名称")
    private String dosageFormName;
}
