package com.elitescloud.cloudt.sys.component.med;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serial;

/**
 * 医药基础实体类-单据主表.
 *
 * @author nc
 * @date 2025/9/15 周一
 */
@Getter
@Setter
@MappedSuperclass
public class BaseModelMedOrder extends CustomFieldBaseModel {
    @Serial
    private static final long serialVersionUID = 8543635117696143981L;

    @ApiModelProperty("来源单据类别 [UDC]SUPP:DOC_CLS")
    @Column(name="root_doc_cls" , columnDefinition = "varchar(64)  comment '来源单据类别 [UDC]SUPP:DOC_CLS'")
    String rootDocCls;

    @ApiModelProperty("来源单据类型")
    @Column(name="root_doc_type" , columnDefinition = "varchar(64)  comment '来源单据类型'")
    String rootDocType;

    @ApiModelProperty("来源单据Id")
    @Column(name="root_doc_id" , columnDefinition = "bigint default 0   comment '来源单据Id'")
    Long rootDocId;

    @ApiModelProperty("来源单据编号")
    @Column(name="root_doc_no" , columnDefinition = "varchar(64)  comment '来源单据编号'")
    String rootDocNo;

//    @ApiModelProperty("关联单据类别 [UDC]SUPP:DOC_CLS")
//    @Column(name="relate_doc_cls" , columnDefinition = "varchar(64)  comment '关联单据类别 [UDC]SUPP:DOC_CLS'")
//    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    @Column(name="relate_doc_type" , columnDefinition = "varchar(64)  comment '关联单据类型'")
    String relateDocType;
    @ApiModelProperty("关联单据类别 默认入库单 [UDC] yst-inv:INV_DOC_CLS")
    @Column(name="relate_doc_cls" , columnDefinition = "varchar(255)  comment '关联单据类别 默认入库单 [UDC] yst-inv:INV_DOC_CLS，多个已逗号给开'")
    String relateDocCls;
    @ApiModelProperty("关联单据ID")
    @Column(name="relate_doc_id" , columnDefinition = "bigint default 0  comment '关联单据ID'")
    Long relateDocId;
    @ApiModelProperty("关联单据编号")
    @Column(name="relate_doc_no" , columnDefinition = "varchar(255)  comment '关联单据编号 入库单单号，多个已逗号给开'")
    String relateDocNo;


    @ApiModelProperty("关联单据2类别 [UDC]SUPP:DOC_CLS")
    @Column(name="relate_doc2_cls" , columnDefinition = "varchar(64)  comment '关联单据2类别 [UDC]SUPP:DOC_CLS'")
    String relateDoc2Cls;

    @ApiModelProperty("关联单据2类型")
    @Column(name="relate_doc2_type" , columnDefinition = "varchar(64)  comment '关联单据2类型'")
    String relateDoc2Type;

    @ApiModelProperty("关联单据2ID")
    @Column(name="relate_doc2_id" , columnDefinition = "bigint default 0  comment '关联单据2ID'")
    Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    @Column(name="relate_doc2_no" , columnDefinition = "varchar(64)  comment '关联单据2编号'")
    String relateDoc2No;


    @ApiModelProperty("客商ID")
    @Column(name="enterprise_id" )
    @Comment("客商ID")
    Long enterpriseId;

    @ApiModelProperty("客商编码")
    @Column(name="enterprise_code"  )
    @Comment("客商编码")
    String enterpriseCode;

    @ApiModelProperty("客商名称")
    @Column(name="enterprise_name"  )
    @Comment("客商名称")
    String enterpriseName;

    @ApiModelProperty(value = "客商客商类型")
    @SysCode(sys = "yst-purc", mod = "ENTERPRISE_TYPE")
    @Column(name="enterprise_type"  )
    @Comment("客商客商类型")
    private String enterpriseType;

    @ApiModelProperty(value = "是否免检")
    @Column(name="qt")
    @Comment("是否免检")
    private Boolean qt;

}
