package com.elitescloud.cloudt.sys.component.med;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 医药基础实体类-订单.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/22 周一
 */
@Getter
@Setter
public class BaseModelMedOrderDVO extends BaseModelVOMedItem {
    @Serial
    private static final long serialVersionUID = 4247834719413430119L;

    @ApiModelProperty(value = "图稿编号")
    private String draftNo;

    @ApiModelProperty(value = "生产日期")
    private LocalDateTime produceDate;

    @ApiModelProperty(value = "有效期至")
    private LocalDateTime expiredDate;
     @ApiModelProperty(value = "产品批号")
    private String productNo;

    @ApiModelProperty(value = "是否赠品")
    private Boolean giftFlag;

    @ApiModelProperty(value = "订货单位")
    private String orderUom;

    @ApiModelProperty(value = "订货数量")
    private BigDecimal orderNum;

    @ApiModelProperty(value = "发货数量")
    private BigDecimal shipNum;

    @ApiModelProperty(value = "应检数量")
    private BigDecimal inspectNum;

    @ApiModelProperty(value = "采购价格")
    private BigDecimal purchasePrice;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo ;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal amt;

    @ApiModelProperty(value = "未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty(value = "合同号")
    private String contractNo;

    @ApiModelProperty(value = "项目编号")
    private String projNo;

    @ApiModelProperty(value = "项目名称")
    private String projName;

}
