package com.elitescloud.cloudt.sys.outlog;

import com.elitescloud.cloudt.common.base.ApiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/9 周三
 */
public class OutsideRetryProviderSPIImpl implements OutsideRetryProviderSPI {
    private static final Logger logger = LoggerFactory.getLogger(OutsideRetryProviderSPIImpl.class);

    private final Set<String> interCodes = Arrays.stream(OutsidePushInter.values()).map(OutsidePushInter::name).collect(Collectors.toSet());

    @Override
    public boolean support(String interCode) {
        return interCodes.contains(interCode);
    }

    @Override
    public ApiResult<String> retryPush(String interCode, Long docId, String docNo) {
        logger.info("采购服务开始重新推送：{}, {}, {}", interCode, docId, docNo);
        switch (OutsidePushInter.valueOf(interCode)) {
            case SRM_PUR_PO_SAVE:
                // 推送采购订单到SRM
                return null;//SpringContextHolder.getBean(PurPoSrmService.class).create(docId);
            case SRM_PUR_PO_CLOSE:
                // 推送关闭采购订单到SRM
                return null;//SpringContextHolder.getBean(PurPoSrmService.class).close(docId);
            case SRM_PUR_PO_CANCEL:
                // 推送取消采购订单到SRM
                return null;//SpringContextHolder.getBean(PurPoSrmService.class).cancelPurPo(docId);
            case SRM_PUR_PO_UPDATE_PAYMENT:
                // 推送采购订单支付状态到SRM
                return null;//SpringContextHolder.getBean(PurPoSrmService.class).updatePayment(docId);
            case SRM_PUR_PG_SAVE:
                // 推送收货单到SRM
                return null;//SpringContextHolder.getBean(PurGrSrmService.class).create(docId);
            case SRM_PUR_RNS_SAVE:
                // 推送采购退货申请单到SRM
                return null;//SpringContextHolder.getBean(PurRnsSrmService.class).create(docId);
            case SRM_PUR_RNS_CANCEL:
                // 推送取消采购退货申请单到SRM
                return null;//SpringContextHolder.getBean(PurRnsSrmService.class).cancel(docId);
            case SRM_PUR_RNS_RECV_SAVE:
                // 推送采购退货出库单到SRM
                return null;//SpringContextHolder.getBean(PurRnsRecvSrmService.class).create(docId);
            case BIP_PUR_GR_SAVE:
                // 推送采购收货单到BIP
                return null;//SpringContextHolder.getBean(BipPurService.class).pushPurGr(docId);
            case BIP_PUR_RNS_RECV_SAVE:
                // 推送采购退货出库单到BIP
                return null;//return SpringContextHolder.getBean(BipPurService.class).pushPurGr(docId);
            case BIP_PUR_AP_SAVE:
                // 推送采购退货出库单到BIP
                return null;//return SpringContextHolder.getBean(BipPurService.class).pushPurAp(docId);
            case NC_SUPP_OU:
                // 推送采购退货出库单到BIP
                return null;//SpringContextHolder.getBean(.class).pushPurAp(docId);
            default:
                throw new RuntimeException("未知的推送接口：" + interCode);
        }
    }
}

