package com.elitesland.yst.common.base;

import com.elitesland.yst.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <pre>
 *     JPA数据实体类的基础类，用于唯一ID生成策略绑定
 *     审计字段、版本和逻辑删除标记，
 *     未来扩展租户ID信息
 * </pre>
 *
 * @author Moz
 * @date 3/17/2020
 */
@Data
@Where(clause = "delete_flag = 0 or delete_flag is null")
@FilterDef(name = "filterByTenantId",defaultCondition =":tenant_id = tenant_id",
        parameters = {@ParamDef(name = "tenant_id",type = "long")}
)
@Filters(@Filter(name = "filterByTenantId",condition = ":tenant_id = tenant_id"))
@EntityListeners(AuditingEntityListener.class)
@MappedSuperclass
public class BaseModel implements Serializable {
    private static final long serialVersionUID = -6696939650444719776L;

    @Id
    @GenericGenerator(name = "el-id", strategy = "com.elitesland.yst.common.util.IdGenerator")
    //@GeneratedValue(strategy = GenerationType.IDENTITY)
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "el-id")
//    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    @Comment("记录唯一ID")
    @Column()
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @Comment(value = "租户ID")
    @Column()
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    @Comment("备注")
    @Column()
    private String remark;

    @ApiModelProperty("记录创建者ID")
    @Comment("记录创建者ID")
    @Column(updatable = false)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    @Comment("记录创建者")
    @Column()
    private String creator;

    @ApiModelProperty("记录创建时间")
    @Comment("记录创建时间")
    @Column(updatable = false)
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者ID")
    @Comment("记录最后更新者ID")
    @Column()
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    @Comment("记录最后更新者")
    @Column()
    String updater;

    @ApiModelProperty("记录最后更新时间")
    @Comment("记录最后更新时间")
    @Column()
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    @Comment("逻辑删除，0：未删除，1：已删除")
    @Column(nullable = false)
    private Integer deleteFlag = 0;


    @ApiModelProperty(value = "锁版本")
    @Comment("锁版本")
    @Column()
    private Integer auditDataVersion;


    @ApiModelProperty("数据归属组织id")
    @Comment("sec_bu_id")
    @Column()
    private Long secBuId;

    @ApiModelProperty("数据归属雇员id")
    @Comment("sec_user_id")
    @Column()
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @Comment("sec_ou_id")
    @Column()
    private Long secOuId;

}
