package com.elitesland.yst.common.config;

import com.elitesland.yst.common.constant.SysConstants;
import org.apache.commons.collections4.map.HashedMap;
import org.redisson.api.RedissonClient;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.CacheConfigSupport;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;

/**
 * @author Michael Li
 * @date AD 2021.04.27 23:27
 */
@Configuration
public class CacheRedisConfig extends CacheConfigSupport {
    @Value("${redis.prefix:#{''}}")
    private String prefix;

    @Bean
    public KeyGenerator permissionRoleKeyGenerator() {
        return (target, method, params) -> {
            return SysConstants.ALL_PERMISSIONS_ROLES;
        };
    }

    @Bean
    @Primary
    @Autowired
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        return new RedisCacheManager(RedisCacheWriter.lockingRedisCacheWriter(redisConnectionFactory),
                RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().prefixCacheNameWith(prefix));
    }

    @Bean
    @Autowired
    public CacheManager redissonManager(RedissonClient redissonClient){
        HashedMap<String, CacheConfig> configHashedMap=new HashedMap<>();
        configHashedMap.put(prefix + "longCache", new CacheConfig(180000, 120000));
        configHashedMap.put(prefix + "shortCache", new CacheConfig(60000, 30000));
        return new RedissonSpringCacheManager(redissonClient, configHashedMap);
    }
}
