package com.elitesland.yst.common.util.noifutils;

/**
 * <p>
 *   no use if utils
 * <p>
 *
 * @author Roman.Zhang
 * @date 2021/12/11
 */
public class VUtils {

    /**
     *  如果参数为true抛出异常
     *
     *  example:
     *
     *
     * @param b
     * @return com.elitesland.yst.utils.noifutils.ThrowExceptionFunction
     **/
    public static ThrowExceptionFunction isTure(boolean b){

        return (errorMessage) -> {
            if (b){
                throw new RuntimeException(errorMessage);
            }
        };
    }

    /**
     * 参数为true或false时，分别进行不同的操作
     *
     * @param b
     * @return com.elitesland.yst.utils.noifutils.BranchHandleFunction
     **/
    public static BranchHandleFunction isTureOrFalse(boolean b){

        return (trueHandle, falseHandle) -> {
            if (b){
                trueHandle.run();
            } else {
                falseHandle.run();
            }
        };
    }

    /**
     * 参数为true或false时，分别进行不同的操作
     *
     * @param str
     * @return com.elitesland.yst.utils.noifutils.PresentOrElseHandlerFunction
     **/
    public static PresentOrElseHandlerFunction<?> isBlankOrNoBlank(String str){

        return (consumer, runnable) -> {
            if (str == null || str.length() == 0){
                runnable.run();
            } else {
                consumer.accept(str);
            }
        };
    }

}
