/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.annotation;

import com.elitesland.yst.common.annotation.Comment;
import com.elitesland.yst.common.base.BaseModel;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

@org.springframework.stereotype.Component
public class CommentIntegrator
implements Integrator {
    public static final CommentIntegrator INSTANCE = new CommentIntegrator();

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.processComment(metadata);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
    }

    private void processComment(Metadata metadata) {
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            Property identifierProperty;
            Class clz = persistentClass.getMappedClass();
            if (clz.isAnnotationPresent(Comment.class)) {
                Comment comment = clz.getAnnotation(Comment.class);
                persistentClass.getTable().setComment(comment.value());
            }
            if ((identifierProperty = persistentClass.getIdentifierProperty()) != null) {
                this.fieldComment(persistentClass, identifierProperty.getName());
            } else {
                Component component = persistentClass.getIdentifierMapper();
                if (component != null) {
                    Iterator iterator = component.getPropertyIterator();
                    while (iterator.hasNext()) {
                        this.fieldComment(persistentClass, ((Property)iterator.next()).getName());
                    }
                }
            }
            Iterator iterator = persistentClass.getPropertyIterator();
            while (iterator.hasNext()) {
                this.fieldComment(persistentClass, ((Property)iterator.next()).getName());
            }
        }
    }

    private void fieldComment(PersistentClass persistentClass, String columnName) {
        block8: {
            try {
                String annotationName;
                Field field = null;
                Class superClz = persistentClass.getMappedClass().getSuperclass();
                if (superClz == BaseModel.class) {
                    try {
                        field = superClz.getDeclaredField(columnName);
                    }
                    catch (NoSuchFieldException | SecurityException exception) {
                        // empty catch block
                    }
                }
                if (field == null) {
                    field = persistentClass.getMappedClass().getDeclaredField(columnName);
                }
                if (!field.isAnnotationPresent(Comment.class)) break block8;
                if (field.isAnnotationPresent(javax.persistence.Column.class) && !(annotationName = field.getAnnotation(javax.persistence.Column.class).name().trim()).isEmpty()) {
                    columnName = annotationName;
                }
                String comment = field.getAnnotation(Comment.class).value();
                Iterator columnIterator = persistentClass.getTable().getColumnIterator();
                while (columnIterator.hasNext()) {
                    Column column = (Column)columnIterator.next();
                    if (!columnName.equalsIgnoreCase(column.getName().replace("_", ""))) continue;
                    column.setComment(comment);
                    break;
                }
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
    }
}

