/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.config;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
public class DataSourceHealthConfig
extends DataSourceHealthContributorAutoConfiguration {
    public DataSourceHealthConfig(Map<String, DataSource> dataSources, ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
        super(dataSources, metadataProviders);
    }

    protected AbstractHealthIndicator createIndicator(DataSource source) {
        if (source instanceof AbstractRoutingDataSource) {
            RoutingDataSourceHealthIndicator routingDataSourceHealthIndicator = new RoutingDataSourceHealthIndicator();
            routingDataSourceHealthIndicator.health();
            return routingDataSourceHealthIndicator;
        }
        DataSourceHealthIndicator indicator = (DataSourceHealthIndicator)super.createIndicator(source);
        indicator.setQuery("select 1");
        return indicator;
    }

    static class RoutingDataSourceHealthIndicator
    extends AbstractHealthIndicator {
        RoutingDataSourceHealthIndicator() {
        }

        protected void doHealthCheck(Health.Builder builder) throws Exception {
            builder.unknown().withDetail("routing", (Object)true);
        }
    }
}

