/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.exception.handler;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BadCaptchaException;
import com.elitesland.yst.common.exception.BadJwtTokenException;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.util.ThrowableUtil;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.ws.rs.BadRequestException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String EXP_NO_PROVIDER_AVAILABLE = "No provider available";
    private static final String EXP_NO_PROVIDER_AVAILABLE1 = "because channel is closed";
    private static final String EXP_THREAD_POOL_OVERFLOW = "thread pool is exhausted";

    @ExceptionHandler(value={BadRequestException.class})
    @ResponseBody
    public ApiResult<Object> handleBadRequestException(BadRequestException e) {
        log.error("\u8bf7\u6c42\u9519\u8bef", (Throwable)e);
        return ApiResult.fail(ApiCode.SYSTEM_EXCEPTION, ThrowableUtil.getStackTrace((Throwable)e), null);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public ApiResult<Object> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        log.warn("\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\u6709\u8bef", (Throwable)e);
        return ApiResult.fail(ApiCode.PARAMETER_PARSE_EXCEPTION, ThrowableUtil.getStackTrace((Throwable)e), null);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ApiResult<Object> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.warn("\u8bf7\u6c42\u65b9\u5f0f\u6709\u8bef", (Throwable)e);
        return ApiResult.fail(ApiCode.METHOD_NOT_SUPPORT, ThrowableUtil.getStackTrace((Throwable)e), null);
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public ApiResult<Object> handleBusinessException(BusinessException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        return ApiResult.fail(e.getCode() == null ? ApiCode.BUSINESS_EXCEPTION : e.getCode(), ThrowableUtil.getStackTrace(e), e.getMessage());
    }

    @ExceptionHandler(value={BadCaptchaException.class})
    @ResponseBody
    public ApiResult<Object> handleBadCaptchaException(BadCaptchaException e) {
        log.error("\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25", (Throwable)((Object)e));
        return ApiResult.fail(ApiCode.VERIFICATION_CODE_EXCEPTION, e.getMessage());
    }

    @ExceptionHandler(value={BadJwtTokenException.class})
    @ResponseBody
    public ApiResult<Object> handleAuthenticationException(BadJwtTokenException e) {
        log.error("\u6743\u9650\u8ba4\u8bc1\u5931\u8d25", (Throwable)((Object)e));
        return ApiResult.fail(ApiCode.UNAUTHENTICATED_EXCEPTION, ThrowableUtil.getStackTrace((Throwable)((Object)e)), null);
    }

    @ExceptionHandler(value={ResourceAccessException.class})
    @ResponseBody
    public ApiResult<Object> handleAuthenticationException(ResourceAccessException e) {
        log.error("\u8bf7\u6c42\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
        return ApiResult.fail(ApiCode.SYSTEM_EXCEPTION, ThrowableUtil.getStackTrace((Throwable)e), null);
    }

    @ExceptionHandler(value={HttpClientErrorException.class})
    @ResponseBody
    public ApiResult<Object> handleHttpClientErrorException(HttpClientErrorException e) {
        log.error("\u8ba4\u8bc1\u6388\u6743\u5f02\u5e38\uff1a", (Throwable)e);
        return ApiResult.fail(ApiCode.AUTHENTICATION_EXCEPTION, ThrowableUtil.getStackTrace((Throwable)e), null);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ApiResult<Object> handleException(Exception e) {
        log.error("\u540e\u7aef\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
        return ApiResult.fail(ApiCode.SYSTEM_EXCEPTION, ThrowableUtil.getStackTrace(e), null);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, MethodArgumentNotValidException.class, ConstraintViolationException.class, ValidationException.class})
    @ResponseBody
    public ApiResult<Object> handleArgumentInvalidException(Exception exception) {
        log.info("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a{}", (Object)exception.getMessage());
        if (exception instanceof IllegalArgumentException) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, exception.getMessage());
        }
        if (exception instanceof MethodArgumentNotValidException) {
            String msg = ((ObjectError)((MethodArgumentNotValidException)exception).getBindingResult().getAllErrors().get(0)).getDefaultMessage();
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, msg);
        }
        if (exception instanceof ConstraintViolationException) {
            String msg = ((ConstraintViolation[])((ConstraintViolationException)exception).getConstraintViolations().toArray(ConstraintViolation[]::new))[0].getMessage();
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, msg);
        }
        if (exception instanceof ValidationException) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, exception.getMessage());
        }
        return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, ExceptionUtil.getRootCause((Throwable)exception).getMessage());
    }

    @ExceptionHandler(value={RpcException.class})
    @ResponseBody
    public ApiResult<Object> handleRpcException(RpcException exception) {
        log.error("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25", (Throwable)exception);
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)exception);
        if (rootCause instanceof TimeoutException) {
            return ApiResult.fail(ApiCode.SERVER_RESPONSE_TIMEOUT, ThrowableUtil.getStackTrace((Throwable)exception), "\u8bf7\u6c42\u8d85\u65f6");
        }
        String rootCauseMsg = rootCause.getMessage();
        if (StrUtil.contains((CharSequence)rootCauseMsg, (CharSequence)EXP_NO_PROVIDER_AVAILABLE) || StrUtil.contains((CharSequence)rootCauseMsg, (CharSequence)EXP_NO_PROVIDER_AVAILABLE1)) {
            return ApiResult.fail(ApiCode.CLOUD_SERVICE_UNAVAILABLE, ThrowableUtil.getStackTrace((Throwable)exception), "\u7cfb\u7edf\u7ef4\u62a4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (StrUtil.contains((CharSequence)rootCauseMsg, (CharSequence)EXP_THREAD_POOL_OVERFLOW)) {
            return ApiResult.fail(ApiCode.THREAD_OVERFLOW, ThrowableUtil.getStackTrace((Throwable)exception), "\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return ApiResult.fail(ApiCode.CLOUD_SERVICE_EXCEPTION, ThrowableUtil.getStackTrace((Throwable)exception), null);
    }

    @ExceptionHandler(value={DataAccessResourceFailureException.class})
    @ResponseBody
    public ApiResult<Object> handleDataAccessException(DataAccessResourceFailureException exception) {
        return ApiResult.fail(ApiCode.DAO_EXCEPTION, ThrowableUtil.getStackTrace((Throwable)exception), "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

