/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="redis.redlock-instance-config", name={"enabled"}, havingValue="true")
public class RedLockUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedissonClient redissonClient0;
    private RedissonClient redissonClient1;
    private RedissonClient redissonClient2;
    @Value(value="${redis.prefix:#{''}}")
    private String prefix;

    @Autowired
    public void setRedissonClient0(@Qualifier(value="redis_single_client0") RedissonClient redissonClient0) {
        this.redissonClient0 = redissonClient0;
    }

    @Autowired
    public void setRedissonClient1(@Qualifier(value="redis_single_client1") RedissonClient redissonClient1) {
        this.redissonClient1 = redissonClient1;
    }

    @Autowired
    public void setRedissonClient2(@Qualifier(value="redis_single_client2") RedissonClient redissonClient2) {
        this.redissonClient2 = redissonClient2;
    }

    public RedissonRedLock getRedLock(String lockName) {
        RLock lock0 = this.redissonClient0.getLock(this.prefix + "RedLock::" + lockName);
        RLock lock1 = this.redissonClient1.getLock(this.prefix + "RedLock::" + lockName);
        RLock lock2 = this.redissonClient2.getLock(this.prefix + "RedLock::" + lockName);
        return new RedissonRedLock(new RLock[]{lock0, lock1, lock2});
    }

    public boolean isHeldByThread(String lockName, Long threadId) {
        boolean status0 = this.redissonClient0.getLock(this.prefix + "RedLock::" + lockName).isHeldByThread(threadId.longValue());
        boolean status1 = this.redissonClient1.getLock(this.prefix + "RedLock::" + lockName).isHeldByThread(threadId.longValue());
        boolean status2 = this.redissonClient2.getLock(this.prefix + "RedLock::" + lockName).isHeldByThread(threadId.longValue());
        return status0 && status1 && status2;
    }
}

