/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.common.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RsaUtils {
    private static final String SRC = "123456";

    public static void main(String[] args) throws Exception {
        System.out.println("\n");
        RsaKeyPair keyPair = RsaUtils.generateKeyPair();
        System.out.println("\u516c\u94a5\uff1a" + keyPair.getPublicKey());
        System.out.println("\u79c1\u94a5\uff1a" + keyPair.getPrivateKey());
        System.out.println("\n");
        RsaUtils.test1(keyPair);
        System.out.println("\n");
        RsaUtils.test2(keyPair);
        System.out.println("\n");
    }

    private static void test1(RsaKeyPair keyPair) throws Exception {
        System.out.println("***************** \u516c\u94a5\u52a0\u5bc6\u79c1\u94a5\u89e3\u5bc6\u5f00\u59cb *****************");
        String text1 = RsaUtils.encryptByPublicKey(keyPair.getPublicKey(), SRC);
        String text2 = RsaUtils.decryptByPrivateKey(keyPair.getPrivateKey(), text1);
        System.out.println("\u52a0\u5bc6\u524d\uff1a123456");
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + text1);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + text2);
        if (SRC.equals(text2)) {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e00\u81f4\uff0c\u89e3\u5bc6\u6210\u529f");
        } else {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e0d\u4e00\u81f4\uff0c\u89e3\u5bc6\u5931\u8d25");
        }
        System.out.println("***************** \u516c\u94a5\u52a0\u5bc6\u79c1\u94a5\u89e3\u5bc6\u7ed3\u675f *****************");
    }

    private static void test2(RsaKeyPair keyPair) throws Exception {
        System.out.println("***************** \u79c1\u94a5\u52a0\u5bc6\u516c\u94a5\u89e3\u5bc6\u5f00\u59cb *****************");
        String text1 = RsaUtils.encryptByPrivateKey(keyPair.getPrivateKey(), SRC);
        String text2 = RsaUtils.decryptByPublicKey(keyPair.getPublicKey(), text1);
        System.out.println("\u52a0\u5bc6\u524d\uff1a123456");
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + text1);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + text2);
        if (SRC.equals(text2)) {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e00\u81f4\uff0c\u89e3\u5bc6\u6210\u529f");
        } else {
            System.out.println("\u89e3\u5bc6\u5b57\u7b26\u4e32\u548c\u539f\u59cb\u5b57\u7b26\u4e32\u4e0d\u4e00\u81f4\uff0c\u89e3\u5bc6\u5931\u8d25");
        }
        System.out.println("***************** \u79c1\u94a5\u52a0\u5bc6\u516c\u94a5\u89e3\u5bc6\u7ed3\u675f *****************");
    }

    public static String decryptByPublicKey(String publicKeyText, String text) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyText));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        byte[] result = cipher.doFinal(Base64.decodeBase64((String)text));
        return new String(result);
    }

    public static String encryptByPrivateKey(String privateKeyText, String text) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyText));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        byte[] result = cipher.doFinal(text.getBytes());
        return Base64.encodeBase64String((byte[])result);
    }

    public static String decryptByPrivateKey(String privateKeyText, String text) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec5 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyText));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec5);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] result = cipher.doFinal(Base64.decodeBase64((String)text));
        return new String(result);
    }

    public static String encryptByPublicKey(String publicKeyText, String text) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec2 = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyText));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec2);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        byte[] result = cipher.doFinal(text.getBytes());
        return Base64.encodeBase64String((byte[])result);
    }

    public static RsaKeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        String publicKeyString = Base64.encodeBase64String((byte[])rsaPublicKey.getEncoded());
        String privateKeyString = Base64.encodeBase64String((byte[])rsaPrivateKey.getEncoded());
        return new RsaKeyPair(publicKeyString, privateKeyString);
    }

    public static class RsaKeyPair {
        private final String publicKey;
        private final String privateKey;

        public RsaKeyPair(String publicKey, String privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }
}

