package com.elitesland.cbpl.b2b.iam.provider;

import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.b2b.Application;
import com.elitesland.cbpl.b2b.iam.dto.MallUserDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author eric.hao
 * @since 2024/11/13
 */
@FeignClient(name = Application.NAME, path = UserExtensionRpcService.URI)
@DocumentedFeignApi(description = "用户的登录信息扩展")
public interface UserExtensionRpcService {

    String URI = Application.URI_PREFIX + "/extend/current";

    @PostMapping(value = "/user")
    @DocumentedFeignApi(description = "用户登录，读取电商端的扩展信息")
    MallUserDTO extension(@RequestBody SysUserDTO user);
}