/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.vo.param.TaskDefinePagingParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskDefineSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskDefineDetailVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskDefinePagingVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskDefineRespVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u6d41\u7a0b - \u5b9a\u4e49\u8868"})
@RestController
@RequestMapping(value={"/bpmn/define"})
public class TaskDefineController {
    private static final Logger logger = LoggerFactory.getLogger(TaskDefineController.class);
    private final TaskDefineService taskDefineService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<TaskDefinePagingVO>> list(@RequestBody TaskDefinePagingParamVO query) {
        logger.info("[TaskDefine] query paging param = {}", (Object)query);
        return HttpResult.ok(this.taskDefineService.taskDefinePageBy(query));
    }

    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public HttpResult<List<TaskDefineRespVO>> query(@RequestBody TaskDefineQueryParamVO query) {
        logger.info("[TaskDefine] query list param = {}", (Object)query);
        return HttpResult.ok(this.taskDefineService.taskDefineByParam(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<TaskDefineDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[TaskDefine] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.taskDefineService.taskDefineById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody @Valid TaskDefineSaveParamVO saveParam) {
        logger.info("[TaskDefine] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.taskDefineService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Long> active(@PathVariable(value="id") Long id) {
        logger.info("[TaskDefine] active by id = {}", (Object)id);
        return HttpResult.ok((Object)this.taskDefineService.updateStatusV(id));
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public HttpResult<Long> inactive(@PathVariable(value="id") Long id) {
        logger.info("[TaskDefine] inactive by id = {}", (Object)id);
        return HttpResult.ok((Object)this.taskDefineService.updateStatusX(id));
    }

    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    @PutMapping(value={"/delete"})
    public HttpResult<Void> updateDeleteFlag(@RequestBody List<Long> ids) {
        logger.info("[TaskDefine] batch logic delete by ids = {}", ids);
        this.taskDefineService.updateDeleteFlag(ids);
        return HttpResult.ok();
    }

    public TaskDefineController(TaskDefineService taskDefineService) {
        this.taskDefineService = taskDefineService;
    }
}

