/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstanceDetailVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstancePagingVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u6d41\u7a0b - \u5b9e\u4f8b\u8868"})
@RestController
@RequestMapping(value={"/bpmn/instance"})
public class TaskInstanceController {
    private static final Logger logger = LoggerFactory.getLogger(TaskInstanceController.class);
    private final TaskInstanceService taskInstanceService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<TaskInstancePagingVO>> list(@RequestBody TaskInstancePagingParamVO query) {
        logger.info("[TaskInstance] query paging param = {}", (Object)query);
        return HttpResult.ok(this.taskInstanceService.taskInstancePageBy(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<TaskInstanceDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[TaskInstance] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.taskInstanceService.taskInstanceById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody TaskInstanceSaveParamVO saveParam) {
        logger.info("[TaskInstance] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.taskInstanceService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Void> active(@PathVariable(value="id") Long id) {
        logger.info("[TaskInstance] active by id = {}", (Object)id);
        this.taskInstanceService.updateStatus(id, "1");
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public HttpResult<Void> inactive(@PathVariable(value="id") Long id) {
        logger.info("[TaskInstance] inactive by id = {}", (Object)id);
        this.taskInstanceService.updateStatus(id, "0");
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[TaskInstance] batch physical delete by ids = {}", ids);
        this.taskInstanceService.delete(ids);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    @PutMapping(value={"/delete"})
    public HttpResult<Void> updateDeleteFlag(@RequestBody List<Long> ids) {
        logger.info("[TaskInstance] batch logic delete by ids = {}", ids);
        this.taskInstanceService.updateDeleteFlag(ids);
        return HttpResult.ok();
    }

    public TaskInstanceController(TaskInstanceService taskInstanceService) {
        this.taskInstanceService = taskInstanceService;
    }
}

