/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.context.StandardContext;
import com.elitesland.cbpl.bpmn.service.TaskClientService;
import com.elitesland.cbpl.bpmn.service.TaskVersionService;
import com.elitesland.cbpl.bpmn.util.BpmnExecutor;
import com.elitesland.cbpl.bpmn.util.BpmnUtil;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.yomahub.liteflow.flow.LiteflowResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskClientServiceImpl
implements TaskClientService {
    private static final Logger logger = LoggerFactory.getLogger(TaskClientServiceImpl.class);
    private final TaskVersionService taskVersionService;

    @Override
    public HttpResult<?> execute(String taskCode, Object paramObj) {
        int version = this.taskVersionService.queryEffectiveVersion(taskCode);
        return this.execute(taskCode, version, paramObj);
    }

    @Override
    public HttpResult<?> execute(String taskCode, Integer version, Object paramObj) {
        LiteflowResponse response = BpmnExecutor.start(BpmnUtil.chainKey(taskCode, version), paramObj);
        if (response.isSuccess()) {
            StandardContext context = (StandardContext)response.getContextBean(StandardContext.class);
            return HttpResult.ok(context.getHttpResult());
        }
        return HttpResult.error((String)response.getCode(), (String)response.getMessage());
    }

    public TaskClientServiceImpl(TaskVersionService taskVersionService) {
        this.taskVersionService = taskVersionService;
    }
}

