/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.convert.TaskVersionConvert;
import com.elitesland.cbpl.bpmn.domain.VersionStatus;
import com.elitesland.cbpl.bpmn.entity.TaskVersionDO;
import com.elitesland.cbpl.bpmn.repo.TaskVersionRepo;
import com.elitesland.cbpl.bpmn.repo.TaskVersionRepoProc;
import com.elitesland.cbpl.bpmn.service.TaskVersionService;
import com.elitesland.cbpl.bpmn.util.BpmnExecutor;
import com.elitesland.cbpl.bpmn.util.BpmnUtil;
import com.elitesland.cbpl.bpmn.vo.param.TaskVersionPagingParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskVersionQueryParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskVersionSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskVersionDetailVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskVersionPagingVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskVersionRespVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskVersionServiceImpl
implements TaskVersionService {
    private static final Logger logger = LoggerFactory.getLogger(TaskVersionServiceImpl.class);
    private final TaskVersionRepo taskVersionRepo;
    private final TaskVersionRepoProc taskVersionRepoProc;

    @Override
    public PagingVO<TaskVersionPagingVO> taskVersionPageBy(TaskVersionPagingParamVO query) {
        long count = this.taskVersionRepoProc.taskVersionCountBy(query);
        if (count > 0L) {
            List<TaskVersionPagingVO> list = this.taskVersionRepoProc.taskVersionPageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public List<TaskVersionRespVO> taskVersionByParam(TaskVersionQueryParamVO query) {
        return this.taskVersionRepoProc.taskVersionByParam(query);
    }

    @Override
    public TaskVersionDetailVO taskVersionById(Long id) {
        Optional taskVersionDO = this.taskVersionRepo.findById(id);
        if (taskVersionDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return TaskVersionConvert.INSTANCE.doToVO((TaskVersionDO)taskVersionDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(TaskVersionSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            TaskVersionDO taskVersionDO = TaskVersionConvert.INSTANCE.saveParamToDO(saveParam);
            taskVersionDO.setStatus(VersionStatus.UN_PUBLISHED.getCode());
            int maxVersion = this.queryMaxVersion(saveParam.getTaskCode());
            taskVersionDO.setVersion(maxVersion + 1);
            this.taskVersionRepo.save(taskVersionDO);
            return taskVersionDO.getId();
        }
        Optional taskVersionDO = this.taskVersionRepo.findById(saveParam.getId());
        if (taskVersionDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        TaskVersionDO taskVersion = (TaskVersionDO)taskVersionDO.get();
        if (!taskVersion.getStatus().equals(VersionStatus.UN_PUBLISHED.getCode())) {
            throw new RuntimeException("\u4ec5" + VersionStatus.UN_PUBLISHED.getDesc() + "\u72b6\u6001\u53ef\u7f16\u8f91");
        }
        TaskVersionConvert.INSTANCE.saveParamMergeToDO(saveParam, taskVersion);
        this.taskVersionRepo.save(taskVersion);
        return taskVersion.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long published(Long id) {
        Optional versionDO = this.taskVersionRepo.findById(id);
        if (versionDO.isEmpty()) {
            throw new RuntimeException("\u53d1\u5e03\u5931\u8d25\uff0c\u7248\u672c\u53c2\u6570\u9519\u8bef");
        }
        TaskVersionDO version = (TaskVersionDO)versionDO.get();
        this.taskVersionRepoProc.unPublished(id, version.getMasId());
        TaskVersionQueryParamVO query = new TaskVersionQueryParamVO();
        query.setMasId(version.getMasId());
        query.setStatus(VersionStatus.EFFECTIVE.getCode());
        List<TaskVersionRespVO> result = this.taskVersionByParam(query);
        result.forEach(row -> BpmnExecutor.destroy(BpmnUtil.chainKey(row.getTaskCode(), row.getVersion())));
        BpmnExecutor.refresh(BpmnUtil.chainKey(version.getTaskCode(), version.getVersion()), version.getTaskSpel());
        return this.taskVersionRepoProc.published(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(Long id) {
        Optional versionDO = this.taskVersionRepo.findById(id);
        if (versionDO.isEmpty()) {
            return 0L;
        }
        TaskVersionDO version = (TaskVersionDO)versionDO.get();
        if (!version.getStatus().equals(VersionStatus.UN_PUBLISHED.getCode())) {
            throw new RuntimeException("\u4ec5" + VersionStatus.UN_PUBLISHED.getDesc() + "\u72b6\u6001\u53ef\u5220\u9664");
        }
        BpmnExecutor.destroy(BpmnUtil.chainKey(version.getTaskCode(), version.getVersion()));
        return this.taskVersionRepoProc.delete(id);
    }

    @Override
    public int queryMaxVersion(String taskCode) {
        return this.taskVersionRepoProc.queryMaxVersion(taskCode);
    }

    @Override
    public int queryEffectiveVersion(String taskCode) {
        return this.taskVersionRepoProc.queryEffectiveVersion(taskCode);
    }

    public TaskVersionServiceImpl(TaskVersionRepo taskVersionRepo, TaskVersionRepoProc taskVersionRepoProc) {
        this.taskVersionRepo = taskVersionRepo;
        this.taskVersionRepoProc = taskVersionRepoProc;
    }
}

