/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.util;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.bpmn.config.BpmnProperties;
import com.elitesland.cbpl.bpmn.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.spi.BpmnContextSpi;
import com.elitesland.cbpl.bpmn.util.BpmnUtil;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.LiteflowResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BpmnExecutor.class);
    private static FlowExecutor flowExecutor;

    private static FlowExecutor getInstance() {
        if (!BpmnProperties.BPMN_ENABLED) {
            throw PhoenixException.unexpected((String)"liteflow not enabled.");
        }
        if (flowExecutor == null) {
            flowExecutor = (FlowExecutor)SpringUtils.getBean(FlowExecutor.class);
        }
        return flowExecutor;
    }

    public static void register(String chainKey, String flowSpEL) {
        LiteFlowChainELBuilder.createChain().setChainId(BpmnUtil.chainKey(chainKey)).setEL(flowSpEL).build();
    }

    public static void refresh(String chainKey, String flowSpEL) {
        BpmnExecutor.destroy(chainKey);
        BpmnExecutor.register(chainKey, flowSpEL);
    }

    public static LiteflowResponse start(String chainKey) {
        return BpmnExecutor.start(chainKey, null);
    }

    public static LiteflowResponse start(String chainKey, Object param) {
        BpmnContextSpi bpmnContextSpi;
        List<Class<?>> extra;
        List<Class<?>> context = BpmnConstant.bpmnCommonContext();
        if (SpringUtils.isPresent(BpmnContextSpi.class) && CollUtil.isNotEmpty(extra = (bpmnContextSpi = (BpmnContextSpi)SpringUtils.getBean(BpmnContextSpi.class)).extraContext())) {
            context.addAll(extra);
        }
        return BpmnExecutor.start(BpmnUtil.chainKey(chainKey), param, context.toArray(new Class[0]));
    }

    public static LiteflowResponse start(String chainKey, Object param, Class<?> ... contextBeanClazzArray) {
        return BpmnExecutor.getInstance().execute2Resp(BpmnUtil.chainKey(chainKey), param, (Class[])contextBeanClazzArray);
    }

    public static boolean containChain(String chainKey) {
        return FlowBus.containChain((String)BpmnUtil.chainKey(chainKey));
    }

    public static void destroy(String chainKey) {
        if (BpmnExecutor.containChain(chainKey)) {
            FlowBus.removeChain((String)BpmnUtil.chainKey(chainKey));
        }
    }

    public static Set<String> chainAll() {
        Map chainMap = FlowBus.getChainMap();
        return chainMap.keySet();
    }
}

