package com.elitesland.cbpl.bpmn.config;

import cn.hutool.core.util.StrUtil;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

import static com.elitesland.cbpl.bpmn.config.BpmnProperties.BPMN_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/03/05
 */
@Data
@ConfigurationProperties(prefix = BPMN_CONFIG_PREFIX)
public class BpmnProperties implements EnvironmentAware {

    public static final String BPMN_CONFIG_PREFIX = "cbpl.bpmn";

    public static boolean BPMN_ENABLED;

    @Override
    public void setEnvironment(Environment environment) {
        // 是否启用：默认关闭
        String property = environment.getProperty("liteflow.enable");
        if (StrUtil.isBlank(property)) {
            property = "false";
        }
        BPMN_ENABLED = Boolean.parseBoolean(property);
    }
}
