package com.elitesland.cbpl.bpmn.context;

import cn.hutool.core.util.ObjectUtil;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * 全局上下文
 *
 * @author eric.hao
 * @since 2024/05/08
 */
@Slf4j
@Data
public class GlobalContext {

    /**
     * 全局公共变量
     */
    private Map<String, String> globalParams = new HashMap<>();

    /**
     * 指定节点中，定义的变量
     */
    private Map<String, Map<String, String>> nodeParams = new HashMap<>();

    /**
     * 获取指定变量值
     *
     * @param key 变量字段
     * @return 变量值
     */
    public String getGlobalParam(String key) {
        return globalParams.get(key);
    }

    /**
     * 保存全局变量
     *
     * @param key   变量字段
     * @param value 变量值
     */
    public void addGlobalParam(String key, String value) {
        globalParams.put(key, value);
    }

    /**
     * 获取节点中，指定变量值
     *
     * @param nodeId 节点唯一标识
     * @param key    变量字段
     * @return 变量值
     */
    public String getNodeParam(String nodeId, String key) {
        Map<String, String> nodeParam = nodeParams.get(nodeId);
        if (ObjectUtil.isNull(nodeParam)) {
            logger.trace("[PHOENIX-BPMN] Invalid Node - {}", nodeId);
            return null;
        }
        return nodeParam.get(key);
    }

    /**
     * 保存节点变量
     *
     * @param nodeId 节点唯一标识
     * @param key    变量字段
     * @param value  变量值
     */
    public void addNodeParam(String nodeId, String key, String value) {
        Map<String, String> nodeParam = nodeParams.get(nodeId);
        if (ObjectUtil.isNull(nodeParam)) {
            nodeParam = new HashMap<>();
        }
        nodeParam.put(key, value);
        nodeParams.put(nodeId, nodeParam);
    }
}
