package com.elitesland.cbpl.bpmn.context;

import com.elitesland.cbpl.bpmn.component.EndComponent;
import com.yomahub.liteflow.flow.LiteflowResponse;
import lombok.Data;
import lombok.Getter;

/**
 * 标准参数上下文
 * <li>负责承载节点的入参、出参</li>
 *
 * @author eric.hao
 * @since 2024/05/07
 */
@Data
public class StandardContext<T> {

    /**
     * 节点参数
     */
    private T data;

    /**
     * 流程结束的输出结果，通常是返回给前端的报文
     */
    private T httpResult;

    /**
     * 获取上一个节点的出参，作为该节点的入参
     */
    public T getPrevParam() {
        return getPrevParam(true);
    }

    /**
     * 调用后，是否删除节点参数
     */
    public T getPrevParam(boolean clear) {
        T param = this.data;
        if (clear) {
            this.data = null;
        }
        return param;
    }

    /**
     * 设置节点出参
     */
    public void setResponse(T response) {
        this.data = response;
    }

    /**
     * 流程输出结果
     * <li>一般用在流程结束，使用{@link LiteflowResponse}获取最后一个节点的输出结果</li>
     */
    public T getHttpResult() {
        return getHttpResult(true);
    }

    /**
     * 调用后，是否删除节点参数
     */
    public T getHttpResult(boolean clear) {
        T param = this.httpResult;
        if (clear) {
            this.httpResult = null;
        }
        return param;
    }

    /**
     * 设置流程输出结果
     * <li>1. 该数据是在{@link EndComponent}，流程结束时设置</li>
     * <li>2. 需保证业务流程的最后一个节点，存在节点出参值</li>
     */
    public void setHttpResult() {
        this.httpResult = this.data;
    }
}
