package com.elitesland.cbpl.bpmn.context;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * ETL数据转换的模板上下文
 *
 * @author eric.hao
 * @since 2024/05/08
 */
@Slf4j
@Data
public class TransformContext {

    /**
     * 模板数据
     * <li>key:节点名称，value:模板编码</li>
     */
    private Map<String, String> templates = new HashMap<>();

    /**
     * 获取模板编码
     *
     * @param nodeId 节点唯一标识
     * @return 模板编码
     */
    public String getTemplateCode(String nodeId) {
        return templates.get(nodeId);
    }
}
