package com.elitesland.cbpl.bpmn.convert;

import com.elitesland.cbpl.bpmn.entity.TaskDefineDO;
import com.elitesland.cbpl.bpmn.vo.param.TaskDefineSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskDefineDetailVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Mapper(config = BaseMapperConfig.class)
public interface TaskDefineConvert {

	TaskDefineConvert INSTANCE = Mappers.getMapper(TaskDefineConvert.class);

    /**
     * DO => RespVO
     */
    TaskDefineDetailVO doToVO(TaskDefineDO taskDefineDO);

    /**
     * SaveParam => DO
     */
    TaskDefineDO saveParamToDO(TaskDefineSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(TaskDefineSaveParamVO saveParam, @MappingTarget TaskDefineDO taskDefineDO);
}
