package com.elitesland.cbpl.bpmn.convert;

import com.elitesland.cbpl.bpmn.entity.TaskInstanceDO;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstanceDetailVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstanceRespVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Mapper(config = BaseMapperConfig.class)
public interface TaskInstanceConvert {

	TaskInstanceConvert INSTANCE = Mappers.getMapper(TaskInstanceConvert.class);

    /**
     * DO => RespVO
     */
    TaskInstanceDetailVO doToVO(TaskInstanceDO taskInstanceDO);

    /**
     * SaveParam => DO
     */
    TaskInstanceDO saveParamToDO(TaskInstanceSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(TaskInstanceSaveParamVO saveParam, @MappingTarget TaskInstanceDO taskInstanceDO);

    /**
     * SavaParam => RespVO
     */
    TaskInstanceRespVO saveParamToVO(TaskInstanceSaveParamVO instance);
}
