package com.elitesland.cbpl.bpmn.domain;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
@Getter
public enum VersionStatus {

    /**
     * 表单发布版本状态
     */
    UN_PUBLISHED(1, "未发布"),
    PUBLISHED(2, "发布成功"),
    EFFECTIVE(3, "生效中"),
    ;

    private final Integer code;
    private final String desc;

    VersionStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(Integer code) {
        for (VersionStatus status : VersionStatus.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
