package com.elitesland.cbpl.bpmn.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.*;
import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * 任务流程 - 定义表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_bpmn_task_define")
@org.hibernate.annotations.Table(appliesTo = "sys_bpmn_task_define", comment = "任务流程 - 定义表")
@ApiModel("任务流程 - 定义表")
public class TaskDefineDO extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 7984388223275764083L;

	/**
	 * 任务编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "任务编码")
	@Column(name = "task_code", nullable = true, length = 64)
	private String taskCode;

	/**
	 * 任务名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "任务名称")
	@Column(name = "task_name", nullable = true, length = 64)
	private String taskName;

	/**
	 * 任务类型：常规(规则)流程、接口调度流程、审批流程、业务流程
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "任务类型：常规(规则)流程、接口调度流程、审批流程、业务流程")
	@Column(name = "task_type", nullable = true, length = 64)
	private String taskType;

	/**
	 * 状态：0禁用；1启用；
	 * nullable : true
	 * default  : 0
	 */
	@ApiModelProperty(value = "状态：0禁用；1启用；")
	@Column(name = "status", nullable = true, length = 11)
	private Integer status;
}
