package com.elitesland.cbpl.bpmn.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.*;
import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务流程 - 实例表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_bpmn_task_instance")
@org.hibernate.annotations.Table(appliesTo = "sys_bpmn_task_instance", comment = "任务流程 - 实例表")
@ApiModel("任务流程 - 实例表")
public class TaskInstanceDO extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 3250737650182063771L;

	/**
	 * 主表ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "主表ID")
	@Column(name = "mas_id", nullable = true, length = 20)
	private Long masId;

	/**
	 * 任务编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "任务编码")
	@Column(name = "task_code", nullable = true, length = 64)
	private String taskCode;

	/**
	 * 版本表ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "版本表ID")
	@Column(name = "ver_id", nullable = true, length = 20)
	private Long verId;

	/**
	 * 版本号
	 * nullable : true
	 * default  : 1
	 */
	@ApiModelProperty(value = "版本号")
	@Column(name = "version", nullable = true, length = 11)
	private Integer version;

	/**
	 * 日志行状态
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "日志行状态")
	@Column(name = "instance_status", nullable = true, length = 20)
	private String instanceStatus;

	/**
	 * 当前任务节点ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "当前任务节点ID")
	@Column(name = "curr_node_id", nullable = true, length = 64)
	private String currNodeId;

	/**
	 * 当前任务节点名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "当前任务节点名称")
	@Column(name = "curr_node_name", nullable = true, length = 64)
	private String currNodeName;

	/**
	 * 错误日志
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "错误日志")
	@Column(name = "error_message", nullable = true, length = 255)
	private String errorMessage;

	/**
	 * 开始时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "开始时间")
	@Column(name = "start_time", nullable = true)
	private LocalDateTime startTime;

	/**
	 * 结束时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "结束时间")
	@Column(name = "end_time", nullable = true)
	private LocalDateTime endTime;
}
