package com.elitesland.cbpl.bpmn.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.*;
import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * 任务流程 - 发布版本表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_bpmn_task_version")
@org.hibernate.annotations.Table(appliesTo = "sys_bpmn_task_version", comment = "任务流程 - 发布版本表")
@ApiModel("任务流程 - 发布版本表")
public class TaskVersionDO extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 9148554813862228231L;

	/**
	 * 主表ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "主表ID")
	@Column(name = "mas_id", nullable = true, length = 20)
	private Long masId;

	/**
	 * 任务编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "任务编码")
	@Column(name = "task_code", nullable = true, length = 64)
	private String taskCode;

	/**
	 * 发布状态：1未发布；2发布成功；3生效中；
	 * nullable : true
	 * default  : 1
	 */
	@ApiModelProperty(value = "发布状态：1未发布；2发布成功；3生效中；")
	@Column(name = "status", nullable = true, length = 11)
	private Integer status;

	/**
	 * 版本号
	 * nullable : true
	 * default  : 1
	 */
	@ApiModelProperty(value = "版本号")
	@Column(name = "version", nullable = true, length = 11)
	private Integer version;

	/**
	 * 全局参数，JSON对象格式字符串
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "全局参数，JSON对象格式字符串")
	@Column(name = "task_param", nullable = true)
	private String taskParam;

	/**
	 * 流程编排SpEL表达式
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "流程编排SpEL表达式")
	@Column(name = "task_spel", nullable = true)
	private String taskSpel;
}
