package com.elitesland.cbpl.bpmn.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.entity.QTaskInstanceDO;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstancePagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
@Component
@RequiredArgsConstructor
public class TaskInstanceRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QTaskInstanceDO taskInstanceDO = QTaskInstanceDO.taskInstanceDO;

    private final QBean<TaskInstancePagingVO> taskInstancePagingVO = Projections.bean(
            TaskInstancePagingVO.class,
            taskInstanceDO.id,
            taskInstanceDO.masId,
            taskInstanceDO.taskCode,
            taskInstanceDO.verId,
            taskInstanceDO.version,
            taskInstanceDO.instanceStatus,
            taskInstanceDO.currNodeId,
            taskInstanceDO.currNodeName,
            taskInstanceDO.errorMessage,
            taskInstanceDO.startTime,
            taskInstanceDO.endTime,
            taskInstanceDO.remark,
            taskInstanceDO.createUserId,
            taskInstanceDO.creator,
            taskInstanceDO.createTime,
            taskInstanceDO.modifyUserId,
            taskInstanceDO.updater,
            taskInstanceDO.modifyTime,
            taskInstanceDO.deleteFlag
    );

    private Predicate pagingWhere(TaskInstancePagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(taskInstanceDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(taskInstanceDO.id.eq(query.getId()));
        }
        if (ObjectUtil.isNotNull(query.getMasId())) {
            predicates.add(taskInstanceDO.masId.eq(query.getMasId()));
        }
        if (StrUtil.isNotBlank(query.getTaskCode())) {
            predicates.add(taskInstanceDO.taskCode.eq(query.getTaskCode()));
        }
        if (ObjectUtil.isNotNull(query.getVerId())) {
            predicates.add(taskInstanceDO.verId.eq(query.getVerId()));
        }
        if (ObjectUtil.isNotNull(query.getVersion())) {
            predicates.add(taskInstanceDO.version.eq(query.getVersion()));
        }
        if (StrUtil.isNotBlank(query.getInstanceStatus())) {
            predicates.add(taskInstanceDO.instanceStatus.eq(query.getInstanceStatus()));
        }
        if (StrUtil.isNotBlank(query.getCurrNodeId())) {
            predicates.add(taskInstanceDO.currNodeId.eq(query.getCurrNodeId()));
        }
        if (StrUtil.isNotBlank(query.getCurrNodeName())) {
            predicates.add(taskInstanceDO.currNodeName.eq(query.getCurrNodeName()));
        }
        if (StrUtil.isNotBlank(query.getErrorMessage())) {
            predicates.add(taskInstanceDO.errorMessage.eq(query.getErrorMessage()));
        }
        if (ObjectUtil.isNotNull(query.getStartTime())) {
            predicates.add(taskInstanceDO.startTime.eq(query.getStartTime()));
        }
        if (ObjectUtil.isNotNull(query.getEndTime())) {
            predicates.add(taskInstanceDO.endTime.eq(query.getEndTime()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(taskInstanceDO.remark.eq(query.getRemark()));
        }
        if (ObjectUtil.isNotNull(query.getCreateUserId())) {
            predicates.add(taskInstanceDO.createUserId.eq(query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank(query.getCreator())) {
            predicates.add(taskInstanceDO.creator.eq(query.getCreator()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(taskInstanceDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyUserId())) {
            predicates.add(taskInstanceDO.modifyUserId.eq(query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank(query.getUpdater())) {
            predicates.add(taskInstanceDO.updater.eq(query.getUpdater()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(taskInstanceDO.modifyTime.eq(query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(taskInstanceDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long taskInstanceCountBy(TaskInstancePagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(taskInstanceDO.id)
                .from(taskInstanceDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TaskInstancePagingVO> taskInstancePageBy(TaskInstancePagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(taskInstancePagingVO)
                .from(taskInstanceDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, taskInstanceDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = jpaQueryFactory.delete(taskInstanceDO)
                .where(taskInstanceDO.id.in(ids));
        return delete.execute();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(taskInstanceDO)
                .set(taskInstanceDO.deleteFlag, 1)
                .where(taskInstanceDO.id.in(ids));
        return update.execute();
    }

    public long update(TaskInstanceSaveParamVO saveParam) {
        JPAUpdateClause update = jpaQueryFactory.update(taskInstanceDO)
                .set(taskInstanceDO.endTime, saveParam.getEndTime())
                .set(taskInstanceDO.errorMessage, saveParam.getErrorMessage())
                .where(taskInstanceDO.id.eq(saveParam.getId()));
        // 实例状态
        if (StrUtil.isNotBlank(saveParam.getInstanceStatus())) {
            update.set(taskInstanceDO.instanceStatus, saveParam.getInstanceStatus());
        }
        // 更新备注
        if (StrUtil.isNotBlank(saveParam.getRemark())) {
            update.set(taskInstanceDO.remark, saveParam.getRemark());
        }
        return update.execute();
    }
}
