package com.elitesland.cbpl.bpmn.service;

import com.elitesland.cbpl.tool.api.domain.HttpResult;

/**
 * @author eric.hao
 * @since 2024/05/10
 */
public interface TaskClientService {

    /**
     * 执行生效中的版本
     *
     * @param taskCode 任务编码
     * @param paramObj 请求参数
     * @return 执行结果
     */
    HttpResult<?> execute(String taskCode, Object paramObj);


    /**
     * 执行指定版本
     *
     * @param taskCode 任务编码
     * @param version  版本号
     * @param paramObj 请求参数
     * @return 执行结果
     */
    HttpResult<?> execute(String taskCode, Integer version, Object paramObj);
}
